/* Copyright (C) 2005 The cairomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __CAIROMM_ENUMS_H
#define __CAIROMM_ENUMS_H

#include <cairo.h>

namespace Cairo
{

#ifndef DOXYGEN_IGNORE_THIS
//This is only used internally, but it must be in a public header because we inline some methods.
typedef cairo_status_t ErrorStatus;
#endif //DOXYGEN_IGNORE_THIS


typedef enum
{
    OPERATOR_CLEAR = CAIRO_OPERATOR_CLEAR,

    OPERATOR_SOURCE = CAIRO_OPERATOR_SOURCE,
    OPERATOR_OVER = CAIRO_OPERATOR_OVER,
    OPERATOR_IN = CAIRO_OPERATOR_IN,
    OPERATOR_OUT = CAIRO_OPERATOR_OUT,
    OPERATOR_ATOP = CAIRO_OPERATOR_ATOP,

    OPERATOR_DEST = CAIRO_OPERATOR_DEST,
    OPERATOR_DEST_OVER = CAIRO_OPERATOR_DEST_OVER,
    OPERATOR_DEST_IN = CAIRO_OPERATOR_DEST_IN,
    OPERATOR_DEST_OUT = CAIRO_OPERATOR_DEST_OUT,
    OPERATOR_DEST_ATOP = CAIRO_OPERATOR_DEST_ATOP,

    OPERATOR_XOR = CAIRO_OPERATOR_XOR,
    OPERATOR_ADD = CAIRO_OPERATOR_ADD,
    OPERATOR_SATURATE = CAIRO_OPERATOR_SATURATE
} Operator;


typedef enum
{
    ANTIALIAS_DEFAULT = CAIRO_ANTIALIAS_DEFAULT,
    ANTIALIAS_NONE = CAIRO_ANTIALIAS_NONE,
    ANTIALIAS_GRAY = CAIRO_ANTIALIAS_GRAY,
    ANTIALIAS_SUBPIXEL = CAIRO_ANTIALIAS_SUBPIXEL
} Antialias;

typedef enum
{
    FILL_RULE_WINDING = CAIRO_FILL_RULE_WINDING,
    FILL_RULE_EVEN_ODD = CAIRO_FILL_RULE_EVEN_ODD
} FillRule;


typedef enum
{
    LINE_CAP_BUTT = CAIRO_LINE_CAP_BUTT,
    LINE_CAP_ROUND = CAIRO_LINE_CAP_ROUND,
    LINE_CAP_SQUARE = CAIRO_LINE_CAP_SQUARE
} LineCap;


typedef enum
{
    LINE_JOIN_MITER = CAIRO_LINE_JOIN_MITER,
    LINE_JOIN_ROUND = CAIRO_LINE_JOIN_ROUND,
    LINE_JOIN_BEVEL = CAIRO_LINE_JOIN_BEVEL
} LineJoin;


typedef enum
{
  FONT_SLANT_NORMAL = CAIRO_FONT_SLANT_NORMAL,
  FONT_SLANT_ITALIC = CAIRO_FONT_SLANT_ITALIC,
  FONT_SLANT_OBLIQUE = CAIRO_FONT_SLANT_OBLIQUE
} FontSlant;

typedef enum
{
  FONT_WEIGHT_NORMAL = CAIRO_FONT_WEIGHT_NORMAL,
  FONT_WEIGHT_BOLD = CAIRO_FONT_WEIGHT_BOLD
} FontWeight;


typedef enum
{
    CONTENT_COLOR = CAIRO_CONTENT_COLOR,
    CONTENT_ALPHA = CAIRO_CONTENT_ALPHA,
    CONTENT_COLOR_ALPHA = CAIRO_CONTENT_COLOR_ALPHA
} Content;


typedef enum
{
    FORMAT_ARGB32 = CAIRO_FORMAT_ARGB32,
    FORMAT_RGB24 = CAIRO_FORMAT_RGB24,
    FORMAT_A8 = CAIRO_FORMAT_A8,
    FORMAT_A1 = CAIRO_FORMAT_A1,
    FORMAT_RGB16_565 = CAIRO_FORMAT_RGB16_565 /* @< @deprecated This format value is deprecated. It has never been properly implemented in cairo and is unnecessary. */
} Format;


typedef enum
{
    EXTEND_NONE = CAIRO_EXTEND_NONE,
    EXTEND_REPEAT = CAIRO_EXTEND_REPEAT,
    EXTEND_REFLECT = CAIRO_EXTEND_REFLECT,
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1,1,1)
    EXTEND_PAD = CAIRO_EXTEND_PAD
#endif /* CAIRO_VERSION > CAIRO_VERSION_ENCODE(1,1,1) */
} Extend;


typedef enum
{
    FILTER_FAST = CAIRO_FILTER_FAST,
    FILTER_GOOD = CAIRO_FILTER_GOOD,
    FILTER_BEST = CAIRO_FILTER_BEST,
    FILTER_NEAREST = CAIRO_FILTER_NEAREST,
    FILTER_BILINEAR = CAIRO_FILTER_BILINEAR,
    FILTER_GAUSSIAN = CAIRO_FILTER_GAUSSIAN
} Filter;

typedef enum
{
    SUBPIXEL_ORDER_DEFAULT = CAIRO_SUBPIXEL_ORDER_DEFAULT,
    SUBPIXEL_ORDER_RGB = CAIRO_SUBPIXEL_ORDER_RGB,
    SUBPIXEL_ORDER_BGR = CAIRO_SUBPIXEL_ORDER_BGR,
    SUBPIXEL_ORDER_VRGB = CAIRO_SUBPIXEL_ORDER_VRGB,
    SUBPIXEL_ORDER_VBGR = CAIRO_SUBPIXEL_ORDER_VBGR
} SubpixelOrder;


typedef enum
{
    HINT_STYLE_DEFAULT = CAIRO_HINT_STYLE_DEFAULT,
    HINT_STYLE_NONE = CAIRO_HINT_STYLE_NONE,
    HINT_STYLE_SLIGHT = CAIRO_HINT_STYLE_SLIGHT,
    HINT_STYLE_MEDIUM = CAIRO_HINT_STYLE_MEDIUM,
    HINT_STYLE_FULL = CAIRO_HINT_STYLE_FULL
} HintStyle;


typedef enum
{
    HINT_METRICS_DEFAULT = CAIRO_HINT_METRICS_DEFAULT,
    HINT_METRICS_OFF = CAIRO_HINT_METRICS_OFF,
    HINT_METRICS_ON = CAIRO_HINT_METRICS_ON
} HintMetrics;

typedef enum
{
    SURFACE_TYPE_IMAGE = CAIRO_SURFACE_TYPE_IMAGE,
    SURFACE_TYPE_PDF = CAIRO_SURFACE_TYPE_PDF,
    SURFACE_TYPE_PS = CAIRO_SURFACE_TYPE_PS,
    SURFACE_TYPE_XLIB = CAIRO_SURFACE_TYPE_XLIB,
    SURFACE_TYPE_XCB = CAIRO_SURFACE_TYPE_XCB,
    SURFACE_TYPE_GLITZ = CAIRO_SURFACE_TYPE_GLITZ,
    SURFACE_TYPE_QUARTZ = CAIRO_SURFACE_TYPE_QUARTZ,
    SURFACE_TYPE_WIN32 = CAIRO_SURFACE_TYPE_WIN32,
    SURFACE_TYPE_BEOS = CAIRO_SURFACE_TYPE_BEOS,
    SURFACE_TYPE_DIRECTFB = CAIRO_SURFACE_TYPE_DIRECTFB,
    SURFACE_TYPE_SVG = CAIRO_SURFACE_TYPE_SVG,
    SURFACE_TYPE_OS2 = CAIRO_SURFACE_TYPE_OS2
} SurfaceType;

typedef enum
{
    PATTERN_TYPE_SOLID = CAIRO_PATTERN_TYPE_SOLID,
    PATTERN_TYPE_SURFACE = CAIRO_PATTERN_TYPE_SURFACE,
    PATTERN_TYPE_LINEAR = CAIRO_PATTERN_TYPE_LINEAR,
    PATTERN_TYPE_RADIAL = CAIRO_PATTERN_TYPE_RADIAL
} PatternType;

typedef enum
{
    FONT_TYPE_TOY = CAIRO_FONT_TYPE_TOY,
    FONT_TYPE_FT = CAIRO_FONT_TYPE_FT,
    FONT_TYPE_WIN32 = CAIRO_FONT_TYPE_WIN32,
    FONT_TYPE_ATSUI = CAIRO_FONT_TYPE_ATSUI
} FontType;

} // namespace Cairo

#endif //__CAIROMM_ENUMS_H

// vim: ts=2 sw=2 et
